module TD 
    ( tdu,
      tdi,
      tdip1,
      tdip2,
      tdip2m
    ) where

import Lib
import Data.Maybe (isJust)
import Data.List (inits)
import Control.Parallel.Strategies (rseq, using, parList)
import Data.Foldable (asum)

tdu :: Integer -> Maybe(Integer,Integer)
tdu n = tdum n (ceilSqrt n)
  
tdum :: Integer -> Integer -> Maybe(Integer,Integer)
tdum n m = f 2
  where f i | i > m = Nothing
            | (n `rem` i) == 0 = Just (i,n `div` i) 
            | otherwise = f (i+1)

spokes :: [Integer] -> [Integer] -> [Integer]
spokes b c = filter (\x -> all (\p -> gcd x p == 1) b) c

wheelc :: Integer -> (Integer,[Integer])
wheelc cMax = (circumference,spokes basis [1,2..circumference-1])
  where basis = last . takeWhile (\x -> product x <= cMax) $ inits primes
        circumference = foldr (*) 1 (basis)

tdi :: Integer -> Integer -> Maybe (Integer,Integer)
tdi n cMax = tdim n (ceilSqrt n) cMax

tdim :: Integer -> Integer -> Integer -> Maybe(Integer,Integer)
tdim n m cMax | isJust s = s
              | otherwise = f c
  where s = tdum n c 
        (c,o) = wheelc cMax
        f i | i > m = Nothing
            | any (\x -> (n `rem` (x + i) == 0)) o = fromCandidates n $ map (+i) o
            | otherwise = f (i+c) 

tdip1 :: Integer -> Integer -> Integer -> Maybe(Integer,Integer)
tdip1 n cMax nT | isJust s = s
                | otherwise = p 1
  where s = tdim n c $ ceilSqrt c
        m = ceilSqrt n
        (c,o) = wheelc cMax
        p i | (c*i) > m = Nothing
            | any isJust il = asum il
            | otherwise = p (i+nT)
            where il = (map pc [c*i,c*(i+1)..c*(i+nT-1)] `using` parList rseq)
        pc i' | any (\x -> (n `rem` (x + i') == 0)) o = fromCandidates n $ map (+i') o
              | otherwise = Nothing

tdip2 :: Integer -> Integer -> Integer -> Integer -> Maybe(Integer,Integer)
tdip2 n cMax nT rpc = tdip2m n (ceilSqrt n) cMax nT rpc

tdip2m :: Integer -> Integer -> Integer -> Integer -> Integer -> Maybe(Integer,Integer)
tdip2m n m cMax nT rpc | isJust s = s
                       | otherwise = p 0
  where s = tdim n c (ceilSqrt c)
        c' = rpc*c
        (c,o) = wheelc cMax
        p i | (c+c'*i) > m = Nothing
            | any isJust il = asum il
            | otherwise = p (i+nT)
            where il = (map (pc 0) [c+c'*i,c+c'*(i+1)..c+c'*(i+nT-1)] `using` parList rseq)
        pc j k | j >= c' = Nothing
               | any (\x -> (n `rem` (x + (j + k)) == 0)) o = fromCandidates n $ map (+ (j+k)) o
               | otherwise = pc (j+c) k
