module Lib
    ( primes,
      ceilSqrt,
      floorSqrt,
      fromCandidates
    ) where

import Math.NumberTheory.Roots (integerSquareRoot) 

primes :: [Integer]
primes = f [2..] where f (p:xs) = p : f [ x | x <- xs, x `mod` p /= 0 ]
                       f _ = undefined

{- This does NOT calculate the actual ceil sqrt -}
ceilSqrt :: Integer -> Integer
ceilSqrt i = integerSquareRoot i + 1

floorSqrt :: Integer -> Integer
floorSqrt = integerSquareRoot

fromCandidates :: Integer -> [Integer] -> Maybe (Integer, Integer)
fromCandidates _ [] = Nothing
fromCandidates n (x:xs) | (n `rem` x == 0 ) = Just(x,n `div` x)
                        | otherwise = fromCandidates n xs
