module Fermat 
    ( fermatm,
      fermatmp
    ) where

import Lib
import Control.Parallel.Strategies (rseq, using, parList)
import Data.Foldable (asum)
import Data.Maybe (isJust)

{-
The following functions are only deterministic under odd inputs
-}

fermatm :: Integer -> Integer -> Maybe(Integer,Integer)
fermatm n m = f $ floorSqrt n
  where f a | b2 < 0 = f $ a+1
            | a - b < m = Nothing
            | b*b == b2 = Just (a-b,a+b)
            | otherwise = f $ a+1
            where b2 = a*a-n
                  b = floorSqrt b2

fermatmp :: Integer -> Integer -> Integer -> Integer -> Maybe(Integer,Integer)
fermatmp n m nT nC = p $ floorSqrt n
  where p a | b2 < 0 = p $ a+1
            | a - b < m = Nothing
            | b*b == b2 = Just (a-b,a+b)
            | any isJust il = asum il
            | otherwise = p $ a+nT*nC
            where il = (map (p' (a+nT*nC)) [a+1..(a+nT)] `using` parList rseq)
                  b2 = a*a-n
                  b = floorSqrt b2
        p' m' a' | b2' < 0 = p' m' $ a'+nT
                 | a' > m' = Nothing
                 | b'*b' == b2' = Just (a'-b',a'+b')
                 | otherwise = p' m' $ a'+nT
                 where b2' = a'*a'-n
                       b' = floorSqrt b2'


