module Main (main) where

import qualified System.Environment as SE (getArgs, getProgName)
import qualified System.Exit as SExit (die)
import qualified Text.Read as TR (read)

import qualified TD as TD (tdu,tdi,tdip1,tdip2,tdip2m)
import qualified Fermat as F (fermatm, fermatmp)

p :: String -> Integer
p = TR.read

main :: IO ()
main = do
  name <- SE.getProgName
  args <- SE.getArgs 
  case args of 
    "tdu":n:[]                  -> print $ TD.tdu     (p n)
    "tdi":n:cMax:[]             -> print $ TD.tdi     (p n)       (p cMax)
    "tdip1":n:cMax:nT:[]        -> print $ TD.tdip1   (p n)       (p cMax) (p nT)
    "tdip2":n:cMax:nT:rpc:[]    -> print $ TD.tdip2   (p n)       (p cMax) (p nT) (p rpc)
    "tdip2m":n:m:cMax:nT:rpc:[] -> print $ TD.tdip2m  (p n) (p m) (p cMax) (p nT) (p rpc)
    "fermatm":n:m:[]            -> print $ F.fermatm  (p n) (p m)
    "fermatmp":n:m:nT:nC:[]     -> print $ F.fermatmp (p n) (p m)          (p nT) (p nC)
    _                           -> SExit.die ("Usage: " ++ name ++ " <algorithm> <N> <+args>")