#include "color.h"

const uint8_t color_palette[256][3] = {
  {0, 0, 0},
  {255, 255, 255},
  {255, 255, 0},
  {158, 79, 113},
  {214, 111, 52},
  {247, 85, 170},
  {229, 121, 13},
  {93, 105, 90},
  {252, 252, 249},
  {176, 163, 146},
  {143, 38, 85},
  {204, 155, 160},
  {197, 231, 115},
  {159, 157, 156},
  {237, 236, 235},
  {161, 85, 36},
  {39, 209, 205},
  {101, 119, 81},
  {83, 160, 88},
  {182, 179, 169},
  {224, 199, 107},
  {193, 188, 187},
  {251, 109, 205},
  {156, 107, 147},
  {156, 169, 153},
  {171, 207, 153},
  {34, 184, 194},
  {165, 162, 160},
  {166, 146, 96},
  {120, 124, 129},
  {118, 197, 197},
  {224, 158, 108},
  {248, 197, 140},
  {132, 174, 118},
  {181, 121, 84},
  {102, 98, 84},
  {223, 182, 139},
  {20, 137, 104},
  {85, 197, 97},
  {221, 216, 204},
  {82, 183, 38},
  {37, 111, 118},
  {211, 151, 114},
  {191, 147, 6},
  {112, 89, 38},
  {101, 99, 98},
  {108, 45, 21},
  {132, 121, 120},
  {179, 136, 112},
  {145, 114, 47},
  {34, 96, 19},
  {114, 114, 113},
  {232, 144, 42},
  {119, 141, 95},
  {154, 105, 14},
  {213, 196, 187},
  {58, 159, 84},
  {122, 76, 29},
  {23, 162, 148},
  {227, 226, 216},
  {138, 105, 54},
  {228, 143, 7},
  {96, 43, 9},
  {108, 161, 88},
  {111, 95, 78},
  {159, 189, 194},
  {153, 106, 92},
  {248, 62, 200},
  {145, 145, 146},
  {196, 181, 160},
  {216, 173, 38},
  {240, 166, 112},
  {117, 77, 39},
  {246, 202, 112},
  {236, 235, 234},
  {248, 160, 18},
  {30, 122, 131},
  {58, 68, 75},
  {181, 103, 58},
  {237, 239, 237},
  {190, 192, 192},
  {123, 114, 106},
  {139, 117, 80},
  {70, 58, 53},
  {109, 45, 21},
  {100, 197, 47},
  {69, 64, 60},
  {125, 129, 133},
  {207, 149, 15},
  {239, 171, 96},
  {101, 96, 88},
  {92, 159, 160},
  {230, 163, 16},
  {185, 155, 137},
  {253, 253, 253},
  {130, 188, 46},
  {241, 215, 171},
  {103, 164, 31},
  {71, 62, 64},
  {158, 211, 90},
  {253, 209, 48},
  {223, 214, 207},
  {247, 51, 142},
  {146, 210, 39},
  {228, 207, 157},
  {146, 57, 1},
  {171, 135, 112},
  {182, 144, 122},
  {153, 210, 163},
  {235, 218, 162},
  {89, 90, 92},
  {234, 224, 162},
  {238, 232, 232},
  {216, 100, 146},
  {212, 153, 180},
  {178, 153, 146},
  {237, 232, 236},
  {24, 162, 147},
  {29, 195, 188},
  {145, 40, 106},
  {174, 111, 138},
  {161, 154, 155},
  {46, 113, 84},
  {172, 138, 44},
  {145, 97, 42},
  {206, 121, 71},
  {222, 207, 119},
  {136, 129, 125},
  {229, 212, 155},
  {15, 12, 12},
  {77, 124, 128},
  {203, 174, 101},
  {214, 204, 157},
  {231, 164, 16},
  {200, 183, 149},
  {109, 106, 92},
  {178, 202, 135},
  {254, 254, 254},
  {229, 126, 69},
  {54, 146, 54},
  {216, 212, 212},
  {51, 60, 67},
  {104, 103, 104},
  {122, 93, 74},
  {167, 208, 207},
  {149, 114, 81},
  {157, 106, 13},
  {104, 107, 104},
  {121, 204, 157},
  {245, 242, 233},
  {183, 139, 116},
  {251, 251, 249},
  {253, 204, 22},
  {250, 199, 109},
  {201, 165, 54},
  {234, 201, 167},
  {35, 99, 29},
  {214, 177, 151},
  {168, 113, 80},
  {178, 135, 47},
  {255, 255, 236},
  {193, 192, 190},
  {227, 231, 216},
  {129, 3, 58},
  {164, 115, 84},
  {232, 234, 232},
  {6, 8, 5},
  {144, 179, 95},
  {175, 150, 139},
  {244, 124, 3},
  {112, 105, 113},
  {2, 7, 2},
  {166, 162, 155},
  {116, 197, 76},
  {243, 239, 229},
  {122, 197, 32},
  {149, 96, 43},
  {164, 169, 158},
  {53, 20, 10},
  {206, 161, 104},
  {233, 221, 211},
  {158, 24, 82},
  {234, 233, 228},
  {107, 103, 89},
  {102, 30, 94},
  {240, 235, 224},
  {21, 153, 74},
  {80, 43, 21},
  {155, 161, 160},
  {212, 174, 156},
  {142, 138, 123},
  {239, 162, 216},
  {72, 113, 117},
  {213, 235, 166},
  {172, 169, 159},
  {104, 81, 46},
  {174, 110, 138},
  {192, 191, 192},
  {165, 154, 159},
  {105, 48, 72},
  {160, 225, 221},
  {208, 141, 105},
  {97, 208, 211},
  {135, 126, 129},
  {222, 242, 240},
  {172, 123, 103},
  {75, 183, 198},
  {239, 186, 145},
  {204, 29, 96},
  {20, 153, 76},
  {173, 145, 99},
  {83, 163, 166},
  {203, 178, 98},
  {128, 189, 195},
  {110, 100, 137},
  {232, 207, 111},
  {252, 249, 246},
  {172, 145, 97},
  {217, 155, 165},
  {113, 1, 50},
  {165, 144, 96},
  {172, 131, 61},
  {11, 8, 5},
  {161, 159, 152},
  {147, 109, 82},
  {75, 121, 24},
  {225, 173, 104},
  {175, 168, 163},
  {143, 204, 94},
  {153, 103, 12},
  {148, 121, 70},
  {110, 30, 44},
  {225, 174, 151},
  {176, 140, 94},
  {60, 106, 15},
  {205, 169, 108},
  {195, 219, 181},
  {9, 4, 6},
  {29, 156, 166},
  {164, 172, 172},
  {207, 98, 105},
  {153, 97, 38},
  {236, 232, 227},
  {66, 113, 55}
};

int color_find_index(uint8_t r, uint8_t g, uint8_t b) {
    for (int i = 0; i < 256; i++) {
        if (color_palette[i][0] == r &&
            color_palette[i][1] == g &&
            color_palette[i][2] == b) {
            return i;
        }
    }
    return 255;
}
