#ifndef GRAPH
#define GRAPH
#include<stdio.h>
#include <jpeglib.h>

typedef struct {
	int width;
	int height;
	float *pixel;
} graph_t;

float *read_jpg(char* file_name, graph_t *graph);

#endif
#include "get_jgp.h"
#include <stdint.h>
#include <math.h>
#include <stdlib.h>

float* resample(int w, int h, float* f){
	int tw = 32, th = 32, ch = 3;
	int t = h * w;

	float dx = w / (float)tw, dy = h / (float)th;
	float *pic;
	pic = (float*)malloc(3*tw*th*sizeof(float));

	for(int i = 0; i < ch; i ++ ) {
		for(int j = 0; j < tw; j ++ ) {
			for(int k = 0; k < th; k ++ ) {
				float x = dx*j, y = dy*k, res = 0;

				int fx = floor((double)x), fy = floor((double)(y));

				float a = x-fx, b = y-fy;
				float lu = f[i*t+fy*h+fx], ld = f[i*t+(fy+1)*h+fx], ru = f[i*t+fy*h+fx+1], rd = f[i*t+(fy+1)*h+fx+1];
				pic[i*tw*th + k*th+j] = (1-a)*(1-b)*lu+a*(1-b)*ru+(1-a)*b*ld+a*b*rd;
			}
		}
	}
	return pic;
}

float* read_jpg(char* file_name, graph_t *graph)
{
	FILE *infile = fopen(file_name, "rb");
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;

	cinfo.err = jpeg_std_error(&jerr);

	jpeg_create_decompress(&cinfo);
	jpeg_stdio_src(&cinfo, infile);
	int rc = jpeg_read_header(&cinfo, TRUE);  //read the jpeg header
	if (rc != 1) {
		printf("JPEG file read fail!!\n");
		exit(rc);
	}

	jpeg_start_decompress(&cinfo);
	int width = cinfo.output_width, cnt = 0;
	int height = cinfo.output_height;
	int channels = cinfo.output_components;

	float *f = (float*)malloc(sizeof(float)*width*height*channels);
	float *f_reordered = (float*)malloc(sizeof(float)*width*height*channels);

	graph->pixel = f_reordered;
	graph->height = height;
	graph->width = width;

	printf("JPEG image is %d x %d with %d color channels\n", width, height, channels);

	unsigned char *buf[1];
	buf[0] = (unsigned char*)malloc(sizeof(unsigned char)*width*cinfo.output_components);

	while (cinfo.output_scanline < cinfo.output_height) {
		jpeg_read_scanlines(&cinfo, &buf[0], 1);
		for(int i = 0; i < width*channels; i ++ ) {
			f[cnt++] = buf[0][i]/255.0;
		}
	}

	float mean[3] = {0.485, 0.456, 0.406};
	float std[3] = {0.229, 0.224, 0.2225};

	int pixel_id = 0;
	for(int i = 0; i < cnt; i ++ ) {
		int curr_chan = i % 3;
		f_reordered[pixel_id + curr_chan * height * width] = (f[i] - mean[curr_chan]) / std[curr_chan]; 
		if (curr_chan == 2) pixel_id++;
	}
	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);
	fclose(infile);
	return f_reordered;
}
