module font_rom(
    input logic clk,
    input logic [3:0] address,  // 4-bit address to store 10 digits (0-9)
    output logic [31:0] data    // 32-bit wide data for 16x20 bitmap (two rows of 16x10 grid)
);
    always_ff @(posedge clk) begin
        case (address)
            4'd0: data <= 32'b1111111111000100010001000111111111111111110010001000100111111111;  // Digit '0'
            4'd1: data <= 32'b0110011100011100010000011111100000000000000011000000011111111111;  // Digit '1'
            4'd2: data <= 32'b1111110001000100010000010000011111111111110010100000010000111111;  // Digit '2'
            4'd3: data <= 32'b1111110001000100001000100111111111111111110011000000011111111111;  // Digit '3'
            4'd4: data <= 32'b1000100010001000111111000100010011111111110010001000100111111111;  // Digit '4'
            4'd5: data <= 32'b1111110001000001000100001111111111111111110010000000000000111111;  // Digit '5'
            4'd6: data <= 32'b1111110001000001000100011111110000000000000011000000011111111111;  // Digit '6'
            4'd7: data <= 32'b1111111111000100001000001000000000000000000010000000011111111111;  // Digit '7'
            4'd8: data <= 32'b1111110001000100010001001111111111111111110010000000000001111111;  // Digit '8'
            4'd9: data <= 32'b1111110001000100001000001111111111110000000011000000011111111111;  // Digit '9'
            default: data <= 32'b00000000000000000000000000000000;  // Default case for invalid address
        endcase
    end
endmodule
