#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 5e-6f;
int nsteps = 1;

void setup(void) {
    // nmos convergence tester
    add_vsrc(0, -1, 3, dc5);    // g
    add_vsrc(1, -1, 4, dc10);    // dd
    add_res(1, 2, 100.0f);      // R_d
    add_nmos(0, 2, -1, 0.02f, 1.5f, 100.0f); // ng=0, nd=2, ns=1
    nnodes = 5;
}

// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,vgs,vds\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g\n",
            t,      // time
            v[0],   
            v[2]   
    );
}
