#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 5e-6f;
int nsteps = 1000;

void setup(void) {
    add_vsrc(4, -1, 5, dc5);    // Vdd
    add_vsrc(0, -1, 6, dc5);
    add_vsrc(1, -1, 7, square5);
    add_nand(0, 1, 2, 3, 4);
    add_cap(2, -1, 1e-6f, time_step);   // output cap
    nnodes = 8;
}

// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,vin,vout\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g\n",
            t,      // time
            v[1],   
            v[2]   
    );
}
