// RC intergrator with opamp (modelled by a vcvs)
#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 5e-6f;
int nsteps = 10000;
int opamp_gain = 1e6f;

void setup(void) {
    add_vsrc(1, -1, 0, dc5);
    add_res(2, 1, 1000.0f);
    add_cap(2, 3, 1e-5f, time_step);
    add_vcvs(3, -1, -1, 2, 4, opamp_gain);
    nnodes = 5;
}

// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,vin,vout\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g\n",
            t,      // time
            v[1],   
            v[3]   
    );
}
