// diode voltage doubler

#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 5e-6f;
int nsteps = 50000;
int opamp_gain = 1e6f;

void setup(void) {
    add_vsrc(0, -1, 1, sin5);
    add_res(0, 2, 1.0f);
    add_cap(2, 3, 1e-6f, time_step);
    add_diode(-1, 3, 1e-15f, 0.025875f);
    add_diode(3, 4, 1e-15f, 0.025875f);
    add_cap(4, -1, 1e-6f, time_step);
    nnodes = 5; 
}

// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,vin,vout\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g\n",
            t,      // time
            v[0],   
            v[4]   
    );
}
