// RD circuit (load line)

#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 5e-6f;
int nsteps = 2;

void setup(void) {
    add_isrc(0, -1, dc5);
    add_res(0, -1, 100.0f);
    add_res(0, 1, 10000.0f);
    add_diode(1, -1, 1e-15f, 0.025875f);
    nnodes = 2;
}

// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,vin,vout\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g\n",
            t,      // time
            v[0],   
            v[1]   
    );
}
