#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 1e-6f;
int nsteps = 10000;

void setup(void) {
    // Node 0, 1: vsrc, vsrc'
    add_vsrc(0, -1, 1, dc5);
    // 2, 3, 4 vin, vin'
    add_vsrc(2, -1, 3, square5);
    add_not(2, 4, 0);
    // 5, 6: CLK
    add_vsrc(5, -1, 6, clk10k);
    // 7, 8: CLK', CLK''
    add_not(5, 7, 0);
    add_not(7, 8, 0);
    // 9-12: master NAND internals
    // 13, 14: master NAND out-
    add_nand(2, 7, 13, 9, 0);
    add_nand(4, 7, 14, 10, 0);
    // 15: 16: master out, out'
    add_nand(13, 16, 15, 11, 0);    // Q master
    add_nand(14, 15, 16, 12, 0);

    // 17-20: slave NAND internals
    // 21, 22: slave NAND out-in
    add_nand(15, 8, 21, 17, 0);
    add_nand(16, 8, 22, 18, 0);
    // 23: 24: slave out, out'
    add_nand(21, 24, 23, 19, 0);
    add_nand(22, 23, 24, 20, 0);

    add_cap(23, -1, 1e-7f, time_step);   // output cap
    /*The output cap's charging period must << CLK period. Otherwise it will fail to charge
    This behavior is expected. Falstad yields similar results.
    For our configuration, 1uF is fine, but beyond 2uF, you will see charging issues*/
    nnodes =25;
}


// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,clk,vin,vout\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g,%g\n",
            t,      // time
            v[5],   // clk node
            v[2],   // vin node
            v[23]   // vout node
    );
}
