#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

/*
IC diagram: https://tinyurl.com/2bg6sjrk
Simplified netlist: https://tinyurl.com/26w4885x
*/

float time_step = 1e-6f;
int nsteps = 10000;

void setup(void) {
    // Node 0, 1: VDD, VDD'
    add_vsrc(0, -1, 1, dc5);
    // 2, 3: current mirror outputs
    add_pmos(2, 2, 0, 0.02f, 1.5f, 0.001f);
    add_nmos(3, 3, -1, 0.02f, 1.5f, 0.001f);
    add_res(2, 3, 1e4f);
    
    // 4-8: comparator 1
    add_pmos(4, 8, 0, 0.02f, 1.5f, 0.001f);
    add_pmos(4, 4, 0, 0.02f, 1.5f, 0.001f);
    add_nmos(6, 8, 7, 0.02f, 1.5f, 0.001f);
    add_nmos(5, 4, 7, 0.02f, 1.5f, 0.001f);
    add_nmos(3, 7,  -1, 0.02f, 1.5f, 0.001f);
    // 9-13: comparator 2
    add_nmos(9, 9, -1, 0.02f, 1.5f, 0.001f);
    add_nmos(9, 13, -1, 0.02f, 1.5f, 0.001f);
    add_pmos(11, 9, 12, 0.02f, 1.5f, 0.001f);
    add_pmos(10, 13, 12, 0.02f, 1.5f, 0.001f);
    add_pmos(2, 12, 0, 0.02f, 1.5f, 0.001f);
    // 555 voltage divider
    add_res(0, 5, 5e3f);
    add_res(5, 11, 5e3f);
    add_res(11, -1, 5e3f);
    // c1': 14
    add_pmos(8, 14, 0, 0.02f, 1.5f, 0.001f);
    add_nmos(3, 14, -1, 0.02f, 1.5f, 0.001f);

    // 15-16: bistable
    add_pmos(2, 15, 0, 0.02f, 1.5f, 0.001f);
    add_pmos(2, 16, 0, 0.02f, 1.5f, 0.001f);
    add_nmos(13, 15, -1, 0.02f, 1.5f, 0.001f);
    add_nmos(14, 16, -1, 0.02f, 1.5f, 0.001f);
    add_nmos(16, 15, -1, 0.02f, 1.5f, 0.001f);
    add_nmos(15, 16, -1, 0.02f, 1.5f, 0.001f);

    // 17-18: inverters
    add_not(16, 17, 0);
    add_not(17, 18, 0);

    // discharge transistor: 19
    add_nmos(17, 19, -1, 0.02f, 1.5f, 0.001f);

    // off-chip driver
    add_res(0, 19, 1e4f);
    add_res(19, 10, 1e4f);
    add_res(10, 6, 0.01f);
    add_cap(6, -1, 3e-8f, time_step);

    nnodes = 20;
}


// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,  vC, dis, vout, vout', vout''\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g,%g, %g, %g\n",
            t,      // time
            v[6],   // clk node
            v[19],   // vin node
            v[16],
            v[17],
            v[18]   // vout node
    );
}
