#include "circuit.h"
#include "driver.h"
#include "input_funcs.h"
#include <string.h>   // for memset

float time_step = 5e-6f;
int nsteps = 10000;
int opamp_gain = 1e6f;

void setup(void) {
    // 4th order filter!
    // 1) Two‑tone voltage source between node 1 → ground(-1), extra I‑unknown = 0
    add_vsrc(1, -1, 0, two_tone);  

    // 2) Stage‑1 Sallen–Key (R1, C1, R2, C2)
    add_res (1, 2, 10000.0f);        // R1 = 10 kΩ 
    add_cap (3, -1, 15.915e-9f, time_step);// C1 = 15.915 nF 
    add_res (2, 3, 10000.0f);        // R2 = 10 kΩ 
    add_cap (2, 4, 15.915e-9f, time_step);// C2 = 15.915 nF 


    add_vcvs(4, -1, 3, 4, 9, 1e6f);  // ideal op‑amp #1

    // 3) Stage‑2 Sallen–Key (identical)
    add_res (4, 5, 10000.0f);        // R1
    add_cap (6, -1, 15.915e-9f, time_step);// C1
    add_res (5, 6, 10000.0f);        // R2
    add_cap (5, 7, 15.915e-9f, time_step);// C2

    //    Non‑inverting gain block for stage‑2: Ra=10 kΩ, Rb≈5.858 kΩ
    add_vcvs(7, -1, 6, 7, 8, opamp_gain);  // ideal op‑amp #2:

    // 4) total number of unknowns = highest node/index + 1
    //    nodes 0–9, so:
    // vout: node 7!
    nnodes = 10;
}

// choose your own header
void print_header(FILE *f) {
    fprintf(f, "time,vin,vmid,vout\n");
}

// choose your own row format
void print_row(FILE *f) {
    // you have access to t, v[], etc.
    fprintf(f, "%g,%g,%g,%g\n",
            t,      // time
            v[1],   
            v[4],
            v[7]   
    );
}
