#ifndef _GAUSSIAN_H
#define _GAUSSIAN_H

#include <linux/ioctl.h>
#include <linux/types.h>

/*
 * Register mapping (24b total)
 * -------------------------------- 
 * |    n (8b)                  |  |
 * ------------------------------  > gaussian_in_t
 * | G | R |    unused (6b)     |  |
 * --------------------------------
 * | D | E | S | unused (5b)    | > gaussian_out_t
 * 
 * First 16b: gaussian_in_t
 * Last 8b: gaussian_out_t
 */

#pragma pack(push, 1)    

typedef struct {
    u8 n;         // 8-bit input
    // next byte: 3 flags + 5 bits reserved
    //u8 g:1;
    //u8 r:1;
    u8 :6;        // unused
    u8 r:1;
    u8 g:1;    
    
} gaussian_in_t;


typedef struct {
    // next byte: 2 flags + 6 bits reserved
    u8 d:1;
    u8 e:1;
    u8 s:1;
    u8 :5;        // unused
//    u8 s:1;
//    u8 e:1;
//    u8 d:1;
} gaussian_out_t;

typedef struct {
  gaussian_in_t input;
  gaussian_out_t output;
} gaussian_arg_t;

#pragma pack(pop)    


/* TODO: check the sizeof the structs */

#define GAUSSIAN_MAGIC 'q'

/* ioctls and their arguments */
#define GAUSSIAN_WRITE _IOW(GAUSSIAN_MAGIC, 1, gaussian_arg_t)
#define GAUSSIAN_READ  _IOR(GAUSSIAN_MAGIC, 2, gaussian_arg_t)
#endif
