/* Temporary input functions list */
#include "input_funcs.h"
#include <math.h>
#include <stdint.h>

float step5(float t)  { return t >= 1e-3f ? 5.0f : 0.0f; }

float dc5  (float t)  { (void)t; return 5.0f; }
float dc10 (float t)  { (void)t; return 10.0f; }
float sin5 (float t)  { return 5.0f * sinf(2.0f*M_PI*1000*t); }
float square5(float t) {
    const float P = 1e-3f, H = P*0.5f;
    float r = fmodf(t,P);
    return (r < H) ? 5.0f : 0.0f;
}
float clk10k(float t) {
    const float P = 1.3e-4f, H = P*0.5f;
    float r = fmodf(t,P);
    return (r < H) ? 5.0f : 0.0f;
}
// two‑tone source: 100 Hz + 10 kHz, 1 V each
float two_tone(float t) {
    return sinf(2.0f * M_PI * 100.0f * t)
         + sinf(2.0f * M_PI * 10000.0f * t);
}
float ramp5(float t) {return 1e3f * t;}
