#ifndef _GAUSSIAN_H
#define _GAUSSIAN_H

#include <sys/ioctl.h>
#include <stdint.h>

/*
 * Register mapping (24b total)
 * -------------------------------- 
 * |    n (8b)                  |  |
 * ------------------------------  > gaussian_in_t
 * | G | R |    unused (6b)     |  |
 * --------------------------------
 * | D | E | S | unused (5b)    | > gaussian_out_t
 * 
 * First 16b: gaussian_in_t
 * Last 8b: gaussian_out_t
 */

#pragma pack(push, 1)    

typedef struct {
    uint8_t n;         // 8-bit input
    // next byte: 3 flags + 5 bits reserved
//    uint8_t g:1;
//    uint8_t r:1;
    uint8_t :6;        // unused
    uint8_t r:1;
    uint8_t g:1;    
    
} gaussian_in_t;


typedef struct {
    // next byte: 2 flags + 6 bits reserved
    uint8_t d:1;
    uint8_t e:1;
    uint8_t s:1;
    uint8_t :5;        // unused
} gaussian_out_t;

typedef struct {
  gaussian_in_t input;
  gaussian_out_t output;
} gaussian_arg_t;


void print_in(int);

gaussian_out_t get_out(int);

void set_in(const gaussian_in_t*, int);



/* TODO: check the sizeof the structs */

#define GAUSSIAN_MAGIC 'q'

/* ioctls and their arguments */
#define GAUSSIAN_WRITE _IOW(GAUSSIAN_MAGIC, 1, gaussian_arg_t)
#define GAUSSIAN_READ  _IOR(GAUSSIAN_MAGIC, 2, gaussian_arg_t)
#pragma pack(pop)    

#endif
