#include "driver.h"
#include "circuit.h"

// global nodal matrix, state, and time
float G[MAT_SIZE][MAT_SIZE];
float Ivec[MAT_SIZE];

extern float G_sta[MAT_SIZE][MAT_SIZE];
extern float I_sta[MAT_SIZE];
extern float G_lin[MAT_SIZE][MAT_SIZE];
extern float I_lin[MAT_SIZE];
float v[MAT_SIZE], v_prev[MAT_SIZE];
float t;
extern float time_step; // time step for simulation
extern int nsteps;      // number of steps for simulation

float current(int n1, int n2) {
    // if they're not directly connected, G[n1][n2] will be zero
    return -G[n1][n2] * (v[n1] - v[n2]);
}

int main(void) {
    // zero‑out everything
    memset(G,      0, sizeof G);
    memset(Ivec,   0, sizeof Ivec);
    memset(v,      0, sizeof v);
    memset(v_prev, 0, sizeof v_prev);
    t = 0.0f;

    // open CSV
    FILE *fp = fopen("results.csv", "w");
    if (!fp) { perror("fopen"); return 1; }
    print_header(fp);

    // build the circuit (calls your add_*()s)
    setup();

    // simulate
    clear_system();
    stamp_static();
    clear_system_sta();

    for (int n = 0; n < nsteps; n++) {
        t = n * time_step;
        update_all(t);
        print_row(fp); // write a row of data
    }
    fclose(fp);
    return 0;
}