#include "circuit.h"

// API to register components in the circuit

Component comps[MAX_COMPS];
int       ncomps = 0;
int       nnodes = 0;

// — Component registration —
void add_vsrc(int n1,int n2, int ni, TransientSource *src) {
    // ni for an internal node for an extra row in the equation.
    Component *c = &comps[ncomps++];
    c->type      = LIN_T;
    c->stamp_lin = vsrc_stamp;
    c->stamp_nl  = NULL;
    c->update    = NULL;
    c->u.vsrc     = (VSrc){n1,n2, ni, src};
}
void add_isrc(int n1,int n2, TransientSource *src) {
    Component *c = &comps[ncomps++];
    c->type      = LIN_T;
    c->stamp_lin = isrc_stamp;
    c->stamp_nl  = NULL;
    c->update    = NULL;
    c->u.isrc     = (ISrc){n1,n2, src};
}
void add_vcvs(int n1, int n2, int np, int nn, int ni, float A) {
    Component *c = &comps[ncomps++];
    c->type      = STA_T;
    c->stamp_lin = vcvs_stamp;
    c->stamp_nl  = NULL;
    c->update    = NULL;
    c->u.vcvs    = (Vcvs){n1,n2, np, nn, ni, A};
}
void add_vccs(int n1, int n2, int np, int nn, float A) {
    Component *c = &comps[ncomps++];
    c->type      = STA_T;
    c->stamp_lin = vccs_stamp;
    c->stamp_nl  = NULL;
    c->update    = NULL;
    c->u.vccs     = (Vccs){n1,n2, np, nn, A};
}
void add_res(int n1, int n2, float R) {
    Component *c = &comps[ncomps++];
    c->type      = STA_T;
    c->stamp_lin = res_stamp;
    c->stamp_nl  = NULL;
    c->update    = NULL;
    c->u.res     = (Res){n1,n2,R};
}

void add_cap(int n1,int n2,float C,float dt,float v0) {
    Component *c = &comps[ncomps++];
    c->type      = LIN_T;
    c->stamp_lin = cap_stamp_lin;
    c->stamp_nl  = NULL;
    c->update    = cap_update;
    c->u.cap     = (Cap){n1,n2,C,dt,v0,0};   // initial conditions are 0
}

void add_ind(int n1,int n2,float L,float dt, float i0) {
    Component *c = &comps[ncomps++];
    c->type      = LIN_T;
    c->stamp_lin = ind_stamp_lin;
    c->stamp_nl  = NULL;
    c->update    = ind_update;
    c->u.ind     = (Ind){n1,n2,L,dt,0,i0};
}
void add_diode(int n1, int n2, float Is, float Vt) {
    Component *c = &comps[ncomps++];
    c->type      = NL_T;
    c->stamp_lin = NULL;
    c->stamp_nl  = dio_stamp_nl;
    c->update    = dio_update;
    c->u.dio     = (Diode){n1,n2,Is,Vt,1.0f};   // initial guess: 1V
}
void add_nmos(int ng, int nd, int ns, float beta, float Vt, float lambda) {
    // Linear: beta * [(Vgs-Vt) * Vds - Vds^2 / 2]
    // Saturation: 0.5 beta * (Vgs-Vt)^2
    Component *c = &comps[ncomps++];
    c->type      = NL_T;
    c->stamp_lin = NULL;
    c->stamp_nl  = nmos_stamp_nl;
    c->update    = nmos_update;
    c->u.nmos    = (Nmos){ng,nd,ns,beta,Vt, lambda, 2.5f, 2.5f};
}
void add_pmos(int ng, int nd, int ns, float beta, float Vt, float lambda) {
    // everything's negative
    Component *c = &comps[ncomps++];
    c->type      = NL_T;
    c->stamp_lin = NULL;
    c->stamp_nl  = pmos_stamp_nl; 
    c->update    = pmos_update;   
    c->u.pmos    = (Pmos){ng,nd,ns,beta,Vt, lambda, 2.5f, 2.5f};
}

void add_not(int vin, int vout, int vDD) {
    add_nmos(vin, vout, -1, 0.02f, 1.5f, 0.01f);
    add_pmos(vin, vout, vDD, 0.02f, 1.5f, 0.01f);
}

void add_nand(int vina, int vinb, int vout, int vn, int vDD) {
    add_nmos(vina, vout, vn, 0.02f, 1.5f, 0.01f);
    add_nmos(vinb, vn, -1, 0.02f, 1.5f, 0.01f);
    add_pmos(vina, vout, vDD, 0.02f, 1.5f, 0.01f);
    add_pmos(vinb, vout, vDD, 0.02f, 1.5f, 0.01f);
}
