#include <stddef.h>
#include <sys/mman.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdint.h>

#define FPGA_AXI_BASE 0xC0000000
#define FPGA_AXI_SPAN 0x00020000

void *h2p_virtual_base;
volatile unsigned int *axi_pio_ptr = NULL;
volatile unsigned int *axi_pio_read_ptr = NULL;

int main(int argc, char **argv) {
	int fd;
	void *virtual_base;
	float value;
	int idx;
	int read_bool;
	char* stopstring;

	fd = open("/dev/mem", O_RDWR | O_SYNC);
	if (fd == -1) {
		perror("open");
		exit(1);
	}

	virtual_base = mmap(NULL, FPGA_AXI_SPAN, PROT_READ | PROT_WRITE, MAP_SHARED, fd, FPGA_AXI_BASE);

	if (virtual_base == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
	
	if (argc == 4) {
		read_bool = atoi(argv[1]);
		idx = atoi(argv[2]);
		value = atof(argv[3]);
	}

	float *ptr = (float *) virtual_base;
	if (read_bool) {
		printf("Value of the int at %d index in float: %f\n", idx,  ptr[idx]);
	} else {
		ptr[idx] = value;
	}

	

	if (munmap(virtual_base, FPGA_AXI_SPAN) == -1) {
		perror("munmap");
		close(fd);
		exit(1);
	}

	close(fd);
	return 0;
}
