module gaussian_top
(
	input logic clk,
	input logic reset,

	input logic [7:0] csr_writedata,
	input logic csr_write,
	input logic csr_chipselect,
	input logic [1:0] csr_address,
	

	output logic [7:0] csr_readdata,

	input logic [31:0] mem_writedata,
	input logic mem_write,
	input logic [14:0]  mem_address,
	input logic mem_chipselect,
	output logic [31:0] mem_readdata
);
// status and control register logic
logic [7:0] n;
logic go;
logic csr_reset;

logic done;
logic success;
logic singular_out;

always_comb begin
	csr_readdata = {done, ~success, singular_out, 5'b0};
end

always_ff @(posedge clk) begin
	if (csr_chipselect && csr_write)
		case (csr_address)
			2'h0: n <= csr_writedata;
			2'h1: begin 
				go <= csr_writedata[0:0];
				csr_reset <= csr_writedata[1:1];
			end
			endcase
	end


// two port memory instance
logic [31:0] gaussian_writedata;
logic [14:0] gaussian_address;
logic gaussian_write;
logic [31:0] gaussian_readdata;

mem2p mem(
	.address_a(mem_address),
	.address_b(gaussian_address),
	.clock(clk),
	.data_a(mem_writedata),
	.data_b(gaussian_writedata),
	.wren_a(mem_write),
	.wren_b(gaussian_write),
	.q_a(mem_readdata),
	.q_b(gaussian_readdata)
);


// instance of gaussian core
gaussian_elim_compat_tb gaussian(
	.clock(clk),
	.start_in(go),
	.reset(csr_reset),
	.n(n),
	.address(gaussian_address),
	.mem_data(gaussian_writedata),
	.mem_wren(gaussian_write),
	.mem_result(gaussian_readdata),
	.done(done),
	.success(success),
	.singular_out(singular_out)
);


endmodule 
