#include "gaussian.h"

// FSM states for G-row + RHS swapping
typedef enum {
    PS_IDLE,      // not doing anything
    PS_SWAP_G_A,  // read G[k][j] into temp_a
    PS_SWAP_G_B,  // read G[pivot][j] into temp_b
    PS_SWAP_G_WA, // write temp_b → G[k][j]
    PS_SWAP_G_WB, // write temp_a → G[pivot][j]
    PS_SWAP_I_A,  // read I[k] into temp_a
    PS_SWAP_I_B,  // read I[pivot] into temp_b
    PS_SWAP_I_WA, // write temp_b → I[k]
    PS_SWAP_I_WB, // write temp_a → I[pivot]
    PS_DONE
} ps_state_t;

typedef struct {
    // inputs
    int k;          // pivot column
    int n;          // number of rows

    // outputs / state regs
    int  pivot;      
    int  pivot_swap_done; 

    // internal regs
    int  j;

    float temp_a, temp_b;

    ps_state_t state;
} pivot_swapper_t;



void pivot_swapper_init(pivot_swapper_t *st, int k, int n, int pivot);
void pivot_swapper_tick(pivot_swapper_t *st);