#include "pivot.h"
#include "gaussian.h"

// call once at reset
void pivot_finder_init(pivot_finder_t *st, int k) {
    st->k          = k;
    st->pivot_done   = 0;
    st->pivot_error  = 0;
    st->current_row            = 0;
    st->max_val      = 0.0f;
}

// call once per “clock cycle”
void pivot_finder_tick(pivot_finder_t *st) {
    if (!st->pivot_done && !st->pivot_error) {
        if (st->current_row == 0) {     // current row can't be 0, since +1
            // at start of a new pivot search:
            st->max_val  = fabsf(read_float(get_G(st->k, st->k)));
            //printf("initial max: %.2f\n", st->max_val);
            st->pivot    = st->k;   // pivot = k
            st->current_row = st->k + 1; // start scanning from row k+1
        }

        // examine row = k + i
        if (st->current_row < MAT_SIZE) {
            float v = fabsf(read_float(get_G(st->current_row, st->k)));
            //printf("row %d: %.2f\n", st->current_row, v);
            if (v > st->max_val) {
                st->max_val = v;
                st->pivot   = st->current_row;
            }
            st->current_row++;
        }
        else {
             // finished scanning all rows
             st->pivot_done  = 1;
             st->pivot_error = (st->max_val < EPSILON); 
        }

    }
}