// memory.c

// memory access functions, and print matrix utilities

#include "memory.h"

char *memory;

void *get_G(int i, int j) {
    return (void *)(memory + (i << (MAT_SHIFT+FLOAT_SHIFT)) + (j << FLOAT_SHIFT));
}
void *get_I(int i) {
    return (void *)(memory + (MAT_SIZE << (MAT_SHIFT+FLOAT_SHIFT)) + (i << FLOAT_SHIFT));
}
void *get_v(int i) {
    return (void *)(memory + ((MAT_SIZE+1) << (MAT_SHIFT+FLOAT_SHIFT)) + (i << FLOAT_SHIFT));
}

float read_float(void *addr) {
    return *(float *)addr;
}
void write_float(void *addr, float val) {
    memcpy(addr, &val, sizeof(float));
}
