// fsm.h

#pragma once
#include "memory.h"
#include "fp.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Flat FSM states
typedef enum {
    GS_IDLE,        // before start
    // Pivot Finder
    PF_INIT, PF_READ_DIAG, PF_SCAN_CHECK, PF_READ_VAL, PF_EVALUATE,

    // Pivot Swapper (G)
    PS_SWAP_G_A, PS_SWAP_G_B, PS_SWAP_G_WA, PS_SWAP_G_WB,
    // Pivot Swapper (I)
    PS_SWAP_I_A, PS_SWAP_I_B, PS_SWAP_I_WA, PS_SWAP_I_WB,

    // Elimination
    EL_INIT_READ_PIVOT, EL_INIT_SETUP,
    EL_READ_AIK, EL_DIV_START, EL_DIV_WAIT,
    EL_COL_SETUP, EL_READ_COL, EL_READ_ROW,
    EL_MUL_START, EL_MUL_WAIT, EL_SUB_START, EL_SUB_WAIT,
    EL_WRITE_COL, EL_COL_INCREMENT, EL_ROW_INCREMENT,

    // Back-substitution
    BS_READ_I, BS_SETUP,
    BS_READ_A, BS_READ_V,
    BS_MUL_START, BS_MUL_WAIT,
    BS_NEXT_CHECK,
    BS_READ_DIAG, BS_DIV_START, BS_DIV_WAIT,
    BS_ROW_DEC,

    // Control
    GS_CHECK_K, // outer loop k increment
    GS_DONE,
    GS_FAILED
} state_t;

// CSV‐friendly names for top‐level FSM states 
static const char* gs_state_names[] = {
    "GS_IDLE",
    "PF_INIT","PF_READ_DIAG","PF_SCAN_CHECK","PF_READ_VAL","PF_EVALUATE",
    "PS_SWAP_G_A","PS_SWAP_G_B","PS_SWAP_G_WA","PS_SWAP_G_WB",
    "PS_SWAP_I_A","PS_SWAP_I_B","PS_SWAP_I_WA","PS_SWAP_I_WB",
    "EL_INIT_READ_PIVOT","EL_INIT_SETUP","EL_READ_AIK","EL_DIV_START","EL_DIV_WAIT",
    "EL_COL_SETUP","EL_READ_COL","EL_READ_ROW","EL_MUL_START","EL_MUL_WAIT",
    "EL_SUB_START","EL_SUB_WAIT","EL_WRITE_COL","EL_COL_INCREMENT","EL_ROW_INCREMENT",
    "BS_READ_I","BS_SETUP","BS_READ_A","BS_READ_V","BS_MUL_START","BS_MUL_WAIT",
    "BS_NEXT_CHECK","BS_READ_DIAG","BS_DIV_START","BS_DIV_WAIT","BS_ROW_DEC",
    "GS_CHECK_K","GS_DONE"
};

typedef struct {
    // inputs
    int        start, n;
    // outputs
    int        done, success, singular;

    // internals
    state_t    state;               // controls
    int        k;
    int        pivot, row, j;       // pivot finder
    float      max_val, val_buf;
    float      temp_a, temp_b;      // pivot swapper
    int        ei, ej, bi, bj;      // elimination
    float      pivot_val, m, buf_col, buf_row;
    float      sum, mem_I, mem_A, mem_v, mem_diag;  // back sub
    // Floating-point units
    fp_unit_t *div_u, *mul_u, *sub_u;
} gaussian_flat_t;



void gaussian_flat_init(gaussian_flat_t *fsm, int start,  int n, 
    fp_unit_t *sub_u, fp_unit_t *mul_u, fp_unit_t *div_u);

void gaussian_flat_tick(gaussian_flat_t *f);
