#pragma once
#define MAX_FP_LATENCY  6  

typedef struct {
    // — Avalon-ST style I/O ports —
    int type;       // 0=add, 1=sub, 2=mul, 3=div
    int        start;          // pulse this high to launch a new op
    float   a;          // 32-bit IEEE-754 operand A
    float   b;          // 32-bit IEEE-754 operand B

    float   result;         // 32-bit IEEE-754 result
    int        result_valid;   // goes high for one cycle when result is ready
    int    exception;      // flags: NX, OF, UF, DZ, NV (per IEEE-754)

    // — internal pipeline state —
    int        latency;                       // core’s pipeline depth
    float   pipe_data[MAX_FP_LATENCY];     // shifted through at each tick
    int        pipe_valid[MAX_FP_LATENCY];    // marks when each stage has valid data
} fp_unit_t;

// one clock cycle of operation
void altera_fp_tick(fp_unit_t *u);