/*
Dummy altera fp unit emulator
Generated by ChatGPT
Internal is a pipeline, spits out the result after latency cycles
*/
#include "fp.h"

// one cycle of operation
void altera_fp_tick(fp_unit_t *u) {
    // shift the pipeline toward the output
    u->result       = u->pipe_data[0];
    u->result_valid = u->pipe_valid[0];
    for (int i = 0; i < u->latency-1; i++) {
        u->pipe_data[i]  = u->pipe_data[i+1];
        u->pipe_valid[i] = u->pipe_valid[i+1];
    }

    // if a new start came in, compute and enqueue
    if (u->start) {
        // simple software model of the operation:
        float a = *(float*)&u->a;
        float b = *(float*)&u->b;
        float out;
        // decide which op by comparing latencies (or pass in a function ptr)
        switch (u->type){
            case 0: out = a + b; break;    // add
            case 1: out = a - b; break;    // sub
            case 2: out = a * b; break;    // mul
            case 3: out = a / b; break;    // div
            default: out = 0.0f; break;    // error
        }
        u->pipe_data[u->latency-1]  = *(float*)&out;
        u->pipe_valid[u->latency-1] = 1;
        u->start                    = 0;
    } else {
        // no new start → clear the tail-valid
        u->pipe_valid[u->latency-1] = 0;
    }
}
