// debug.c
// helper functions to print the matrix and timing diagram

#include "debug.h"

void print_matrix(float m[][MAT_SIZE], float I[MAT_SIZE], int n) {
  for (int i = 0; i < n; i++) {
      for (int j = 0; j < n; j++)
          printf("%8.4g ", m[i][j]);
      printf(" | %8.4g\n", I[i]);
  }
  printf("\n");
}

void print_matrix_mem(int n){
  for (int i = 0; i < n; i++) {
      for (int j = 0; j < n; j++)
          printf("%8.4g ", read_float(get_G(i,j)));
      printf(" | %8.4g", read_float(get_v(i)));
      printf(" | %8.4g\n", read_float(get_I(i)));
  }
  printf("\n");
}

void print_vector(float v[MAT_SIZE], int n) {
  for (int i = 0; i < n; i++)
      printf("%8.4g ", v[i]);
  printf("\n");
}


// Call once at startup to print the CSV header:
void gaussian_flat_print_header(FILE *fp) {
    fprintf(fp,
      "start,n,done,success,singular,"
      "state,k,"
      "pivot,row,j,max_val,val_buf,"
      "temp_a,temp_b,"
      "ei,ej,bi,bj,pivot_val,m,buf_col,buf_row,"
      "sum,mem_I,mem_A,mem_v,mem_diag,"
      // div unit
      "div_type,div_a,div_b,div_result,div_valid,div_exc,"
      // mul unit
      "mul_type,mul_a,mul_b,mul_result,mul_valid,mul_exc,"
      // sub unit
      "sub_type,sub_a,sub_b,sub_result,sub_valid,sub_exc\n");
}

// Dumps one row of the current FSM state:
void gaussian_flat_print_csv(FILE *fp, const gaussian_flat_t *f) {
    fprintf(fp,
      "%d,%d,"               // start, n
      "%d,%d,%d,"            // done, success, singular
      "%s,"                  // state name
      "%d,"                  // k
      "%d,%d,%d,%g,%g,"      // pivot,row,j,max_val,val_buf
      "%g,%g,"               // temp_a,temp_b
      "%d,%d,%d,%d,%g,%g,%g,%g," // ei,ej,bi,bj,pivot_val,m,buf_col,buf_row
      "%g,%g,%g,%g,%g,"      // sum,mem_I,mem_A,mem_v,mem_diag
      "%d,%g,%g,%g,%d,%d,"   // div_type,div_a,div_b,div_result,div_valid,div_exc
      "%d,%g,%g,%g,%d,%d,"   // mul_type,mul_a,mul_b,mul_result,mul_valid,mul_exc
      "%d,%g,%g,%g,%d,%d\n", // sub_type,sub_a,sub_b,sub_result,sub_valid,sub_exc

      // inputs
      f->start, f->n,
      // outputs
      f->done, f->success, f->singular,
      // state
      gs_state_names[f->state],
      // pivot finder
      f->k,
      f->pivot, f->row, f->j, f->max_val, f->val_buf,
      // swapper
      f->temp_a, f->temp_b,
      // elimination
      f->ei, f->ej, f->bi, f->bj,
      f->pivot_val, f->m, f->buf_col, f->buf_row,
      // back-substitution
      f->sum, f->mem_I, f->mem_A, f->mem_v, f->mem_diag,
      // div unit I/O
      f->div_u->type, f->div_u->a, f->div_u->b,
      f->div_u->result, f->div_u->result_valid, f->div_u->exception,
      // mul unit I/O
      f->mul_u->type, f->mul_u->a, f->mul_u->b,
      f->mul_u->result, f->mul_u->result_valid, f->mul_u->exception,
      // sub unit I/O
      f->sub_u->type, f->sub_u->a, f->sub_u->b,
      f->sub_u->result, f->sub_u->result_valid, f->sub_u->exception
    );
}