/*
Back substitution module, step 4/4
*/
#include "fp.h"
#include <math.h>

typedef enum { 
    SBS_INIT,         // load sum ← I[i], set j ← i+1
    SBS_MUL_START,    // start a * v
    SBS_MUL_WAIT,     // wait for mul_done
    SBS_SUB_START,    // start sum – product
    SBS_SUB_WAIT,     // wait for sub_done
    SBS_NEXT_CHECK,   // bump j or move to DIVIDE
    SBS_DIV_START,    // start sum / diag
    SBS_DIV_WAIT,     // wait for div_done
    SBS_ROW_DONE,     // write v[i], decrement i
    SBS_DONE
} backsub_state_t;

typedef struct {
    // inputs
    int start; // number of rows

    // outputs / state regs
    int backsub;
    int backsub_done;
    int backsub_error;

    //internal regs
    int i;
    int j;
    int k;
    float sum;

    backsub_state_t state;

    // FP units
    fp_unit_t  *mul_u;
    fp_unit_t  *sub_u;
    fp_unit_t  *div_u;
} backsub_t;

void backsub_init(backsub_t *st, int start, fp_unit_t *sub_u, fp_unit_t *mul_u, fp_unit_t *div_u);
void backsub_tick(backsub_t *st);