# File List
- `main.c`: test program for each block
    - Software verfier, matrix checker
- `memory.c`: memory interface
    - Address decoder, reader/writer
- `fp.c`: FP module interface
    - TODO: make the wires well-defined (currently only using a, b, out, exception and checks if out = NaN)
- `fsm.c`: main FSM for Gaussian elimination
    - Defines interface and state logic
- `debug.c`: helper functions to print matrix and export timing diagram

# Test: `main.c`
Simulates hardware blocks cycle-by-cycle, until it's `done`. Check the results
## compilation
Just run `make` and `./main` will go through all current test cases
## Test workflow
1. Prepare the data structures:
    - `char *memory` is allocated by `malloc()`, with the same data structure on the FPGA. They will store the results from/to the hardware
        - first 128*128*4 bytes: $G$ (input)
        - Next 128*4 bytes: $I$ (input)
        - Next 128*4 byres: $v$ (output)
    - `memory` is filled by randomly generated floats
    - `float G[][]`, `float I[]`, `float v[]` are declared on the stack. They will store the reference software program's results. Initially, `G` and `I` are `memcpy()`ed from `memory`'

2. Run Gaussian elimination on both HW and SW
    - If results match, good
    - If results don't match, bad
    - If HW reports singular matrix, it will be reported (this can happen)
    - If HW fails internally (nan), bad

# FSM Interface
- Input: start, n
- Output: done, success, singular
    - When `done = 1`, `success = 1` means there's no internal error
    - When `success = 1`, `singular = 1` means the matrix is singular and can't be solved. This is not a HW error. Just the user's circuit is bad :(
        
TODO: currently the input/output states are a bit clumsy: there might be more states than necessary, just to buffer the input/output signals
