module multiplier
#(parameter WIDTH=18)
(
	input clk,
	input [WIDTH-1:0] X,
	input [WIDTH-1:0] Y,
	output reg [WIDTH-1:0] I1, 
	output reg [WIDTH-1:0] I2,
	output reg [2*WIDTH-1:0] P
);

	// Declare input and output registers
	reg [WIDTH-1:0] dataa_reg;
	reg [WIDTH-1:0] datab_reg;
	wire [2*WIDTH-1:0] mult_out;
	wire [2*WIDTH-1:0] in1;
	wire [2*WIDTH-1:0] in2;

	// Store the result of the multiply
	assign mult_out = dataa_reg * datab_reg;
	assign in1 = dataa_reg;
	assign in2 = datab_reg;
	

	// Update data
	always @ (posedge clk)
	begin
		dataa_reg <= X;
		datab_reg <= Y;
		P <= mult_out;
		I1 <= in1;
		I2 <= in2;
	end

endmodule
