`include "lr_acc.svh"


module comb_mult_4b (
    input  [`MULT_INPUT_SIZE_4b-1:0] opa,
    input  [`MULT_INPUT_SIZE_4b-1:0] opb,
    output [`MULT_OUTPUT_SIZE_8b-1:0] result
);
    wire [`MULT_OUTPUT_SIZE_8b-1:0] p0 = opb[0] ? {4'b0, opa      } : 8'b0;
    wire [`MULT_OUTPUT_SIZE_8b-1:0] p1 = opb[1] ? {3'b0, opa, 1'b0} : 8'b0;
    wire [`MULT_OUTPUT_SIZE_8b-1:0] p2 = opb[2] ? {2'b0, opa, 2'b0} : 8'b0;
    wire [`MULT_OUTPUT_SIZE_8b-1:0] p3 = opb[3] ? {1'b0, opa, 3'b0} : 8'b0;
    
    assign result = p0 + p1 + p2 + p3;

endmodule