`timescale 1ns / 1ps

module tb_unsigned_adder;

  // Parameters
  parameter WIDTH = 16;
  parameter NUM_TESTS = 32;

  // Test signals
  reg [WIDTH-1:0] dataa;
  reg [WIDTH-1:0] datab;
  reg cin;
  wire [WIDTH:0] result;

  // Clock signal
  reg clk;
  initial clk = 0;
  always #5 clk = ~clk;  // 100MHz clock

  // Instantiate DUT
  unsigned_adder #(WIDTH) dut (
    .dataa(dataa),
    .datab(datab),
    .cin(cin),
    .result(result)
  );

  // Test sequence
  integer i;
  reg [WIDTH:0] expected;

  initial begin
    $display("=== Unsigned Adder Testbench Start ===");

    // Wait for global reset
    dataa = 0;
    datab = 0;
    cin = 0;
    #10;

    for (i = 0; i < NUM_TESTS; i = i + 1) begin
      @(posedge clk);

      // Generate input patterns
      dataa = i * 3;
      datab = i * 5;
      cin = 0;

      @(posedge clk);
      expected = dataa + datab + cin;

      #1;
      if (result !== expected)
        $display("[%0t] Test %0d: A=%0d B=%0d Cin=%b → Got %0d, Expected %0d",
                  $time, i, dataa, datab, cin, result, expected);
      else
        $display("[%0t] Test %0d: A=%0d B=%0d Cin=%b → Result = %0d",
                  $time, i, dataa, datab, cin, result);
    end

    $display("=== Unsigned Adder Testbench Complete ===");
    #10;
    $finish;
  end

endmodule
