`timescale 1ns / 1ps

module tb_signed_adder_subtractor;

  // Parameters
  parameter WIDTH = 16;
  parameter NUM_TESTS = 10;

  // DUT Signals
  logic signed [WIDTH-1:0] dataa;
  logic signed [WIDTH-1:0] datab;
  logic add_sub;
  logic clk;
  logic [WIDTH:0] result;

  // Instantiate the DUT
  signed_adder_subtractor #(.WIDTH(WIDTH)) dut (
    .dataa(dataa),
    .datab(datab),
    .add_sub(add_sub),
    .clk(clk),
    .result(result)
  );

  // Clock generation
  initial clk = 0;
  always #5 clk = ~clk;  // 100MHz clock

  // Test variables
  integer i;
  logic signed [WIDTH:0] expected;

  initial begin
    $display("=== Signed Adder/Subtractor Test Start ===");

    // Initialize
    dataa = 0;
    datab = 0;
    add_sub = 0;
    #20;

    for (i = 0; i < NUM_TESTS; i++) begin
      @(posedge clk);
      // Create test inputs (some negative)
      dataa = $random % 32768 - 16384;  // range: -16384 to 16383
      datab = $random % 32768 - 16384;
      add_sub = i % 2;  // Alternate between add and subtract

      // Compute expected result
      if (add_sub)
        expected = dataa + datab;
      else
        expected = dataa - datab;

      @(posedge clk);
      #1;

      if (result !== expected)
        $display("[%0t] %s: A=%0d, B=%0d → Got %0d, Expected %0d",
                 $time, (add_sub ? "ADD" : "SUB"), dataa, datab, result, expected);
      else
        $display("[%0t] %s: A=%0d, B=%0d → Result = %0d",
                 $time, (add_sub ? "ADD" : "SUB"), dataa, datab, result);
    end

    $display("=== Signed Adder/Subtractor Test Complete ===");
    #10;
    $finish;
  end

endmodule
