`timescale 1ns/1ps
`include "lr_acc.svh"

module tb_lr_acc_8b;

  logic clk, reset, start;
  logic [`SPLIT_DATA_LEN-1:0] x, y;
  logic [`OUTPUT_DATA_LEN-1:0] sum_x, sum_y;
  logic [`MULT_DATA_IN_LEN-1:0] sum_x_squared, sum_xy;
  logic done;

  // Clock Generation
  always #2 clk = ~clk;

  lr_acc_8b dut (
    .clk(clk),
    .reset(reset),
    .start(start),
    .x(x),
    .y(y),
    .sum_x(sum_x),
    .sum_y(sum_y),
    .sum_x_squared(sum_x_squared),
    .sum_xy(sum_xy),
    .done(done)
  );

  initial begin
    // Initialize signals
    clk = 0;
    reset = 1;
    start = 0;
    x = 0;
    y = 0;

    // Wait a few cycles and release reset
    #10;
    reset = 0;

    // Send one input
    @(posedge clk);
    x = 4'b0011;
    y = 4'b0100;
    start = 1;

    @(posedge clk);
    start = 0;


    x = 4'b0110;
    y = 4'b0111;
    start = 1;

    @(posedge clk);
    start = 0;


    x = 4'b1000;
    y = 4'b1000;
    start = 1;

    @(posedge clk);
    start = 0;


    x = 4'd11;
    y = 4'd12;
    start = 1;

    @(posedge clk);
    start = 0;

    x = 4'b0011;
    y = 4'b0100;
    start = 1;

    @(posedge clk);
    start = 0;

    // Wait for done

    // Display results
    $display("Sum X: %d", sum_x);
    $display("Sum Y: %d", sum_y);
    $display("Sum X^2: %d", sum_x_squared);
    $display("Sum XY: %d", sum_xy);

    #10;	
    $finish;
  end

endmodule

