`ifndef __LR_ACC_SVH__
`define __LR_ACC_SVH__

`timescale 1ns/100ps


`ifndef CLOCK_PERIOD
`define CLOCK_PERIOD 10
`endif

`define SPLIT_DATA_LEN 4
`define INPUT_DATA_LEN 8
`define MULT_DATA_IN_LEN 18
`define OUTPUT_DATA_LEN 32


`define MEM_DATA_WIDTH 8
`define MEM_ADDR_WIDTH 9

`define MULT_4B_WIDTH 4

`define DATA_SET_SIZE 512

`define ADDRESS_BITS_SIZE $clog2(`DATA_SET_SIZE)

`define PIPELINE_SETS 16
`define PC_BITS_SIZE $clog2(`PIPELINE_SETS)

`define ADDER_IN_SIZE_18b 18
`define ADDER_OUT_SIZE_18b 18


`define ADDER_INPUT_SIZE_4b 4
`define ADDER_OUTPUT_SIZE_5b 5

`define MULT_INPUT_SIZE_4b 4
`define MULT_OUTPUT_SIZE_8b 8

`define DSP_MULT_IN_SIZE 18
`define DSP_MULT_OUT_SIZE 36

typedef struct packed {
    logic [`SPLIT_DATA_LEN-1:0] x; 
    logic [`SPLIT_DATA_LEN-1:0] y;
} memory;

typedef struct packed {
    logic [`ADDRESS_BITS_SIZE-1:0] pc; 
    logic [`PC_BITS_SIZE-1:0] dut_num;
    logic done;
    logic [`MULT_DATA_IN_LEN-1:0] local_s_2;
    logic [`MULT_DATA_IN_LEN-1:0] local_s_3;
    logic [`MULT_DATA_IN_LEN-1:0] local_s_4;
    logic [`MULT_DATA_IN_LEN-1:0] local_s_5;
} pc_tracker;

`endif
