module multiplier_wrapper (
    input  logic                 clk,
    input  logic                 rst,
    input  logic                 start,
    output logic [35:0]         product_out  // 18x18 product
);

    // Parameters
    localparam WIDTH = 18;

    // Internal signals
    logic [WIDTH-1:0] X, Y;
    logic [2*WIDTH-1:0] P;

    // Instantiate the multiplier
    multiplier #(.WIDTH(WIDTH)) mul_inst (
        .clk(clk),
        .X(X),
        .Y(Y),
        .P(P)
    );

    // FSM state
    typedef enum logic [1:0] {
        IDLE,
        LOAD_INPUTS,
        WAIT_RESULT
    } state_t;

    state_t state;
    logic [7:0] counter;

    always_ff @(posedge clk or posedge rst) begin
        if (rst) begin
            state       <= IDLE;
            X           <= 0;
            Y           <= 0;
            product_out <= 0;
            counter     <= 0;
        end else begin
            case (state)
                IDLE: begin
                    if (start)
                        state <= LOAD_INPUTS;
                end

                LOAD_INPUTS: begin
                    X       <= counter * 2;           // Example data
                    Y       <= counter + 5;
                    counter <= counter + 1;
                    state   <= WAIT_RESULT;
                end

                WAIT_RESULT: begin
                    product_out <= P;
                    state <= IDLE;
                end
            endcase
        end
    end

endmodule
