module memory_wrapper (
    input  logic        clk,
    input  logic        rst,
    input  logic        start,

    output logic [7:0]  read_data
);

    // Parameters
    localparam DATA_WIDTH = 8;
    localparam ADDR_WIDTH = 6;

    // Internal control signals
    logic [DATA_WIDTH-1:0] data_in;
    logic [ADDR_WIDTH-1:0] addr;
    logic                  we;

    // Output from memory
    logic [DATA_WIDTH-1:0] q;

    // Instantiate the RAM
    single_port_ram_with_init #(
        .DATA_WIDTH(DATA_WIDTH),
        .ADDR_WIDTH(ADDR_WIDTH)
    ) ram_inst (
        .data(data_in),
        .addr(addr),
        .we(we),
        .clk(clk),
        .q(q)
    );

    // FSM states (simple demo)
    typedef enum logic [1:0] {
        IDLE,
        WRITE_1,
        WRITE_2,
        READ
    } state_t;

    state_t state;

    // FSM logic
    always_ff @(posedge clk or posedge rst) begin
        if (rst) begin
            state     <= IDLE;
            addr      <= 0;
            data_in   <= 0;
            we        <= 0;
            read_data <= 0;
        end else begin
            case (state)
                IDLE: begin
                    if (start)
                        state <= WRITE_1;
                end

                WRITE_1: begin
                    addr    <= 6'd10;
                    data_in <= 8'hA5;
                    we      <= 1;
                    state   <= WRITE_2;
                end

                WRITE_2: begin
                    addr    <= 6'd20;
                    data_in <= 8'h3C;
                    we      <= 1;
                    state   <= READ;
                end

                READ: begin
                    addr    <= 6'd10;
                    we      <= 0;
                    read_data <= q;  // registered read from address 10
                    state   <= IDLE;
                end
            endcase
        end
    end

endmodule
