`include "lr_acc.svh"

module lr_acc_8b_wrapper (
    input  logic clk,
    input  logic rst,
    input  logic run,
    output logic done_out,
    output logic [`MULT_DATA_IN_LEN-1:0] sum_x,
    output logic [`MULT_DATA_IN_LEN-1:0] sum_y,
    output logic [`MULT_DATA_IN_LEN-1:0] sum_x_squared,
    output logic [`MULT_DATA_IN_LEN-1:0] sum_xy
);

    // Internal signals
    logic start;
    logic [`SPLIT_DATA_LEN-1:0] x, y;
    logic done;

    // Instantiate the lr_acc_8b DUT
    lr_acc_8b dut (
        .clk(clk),
        .reset(rst),
        .start(start),
        .x(x),
        .y(y),
        .sum_x(sum_x),
        .sum_y(sum_y),
        .sum_x_squared(sum_x_squared),
        .sum_xy(sum_xy),
        .done(done)
    );

    // -----------------------
    // Stimulus Generator FSM
    // -----------------------
    typedef enum logic [1:0] {
        IDLE,
        FEED,
        WAIT_DONE
    } state_t;

    state_t state;
    int     count;
    int     max_inputs = 8;

    always_ff @(posedge clk or posedge rst) begin
        if (rst) begin
            state     <= IDLE;
            count     <= 0;
            x         <= 0;
            y         <= 0;
            start     <= 0;
            done_out  <= 0;
        end else begin
            case (state)
                IDLE: begin
                    done_out <= 0;
                    if (run) begin
                        state <= FEED;
                        count <= 0;
                    end
                end

                FEED: begin
                    // Drive new (x, y)
                    x     <= count;         // test values: 0, 1, 2, ...
                    y     <= max_inputs - count;
                    start <= 1;
                    state <= WAIT_DONE;
                end

                WAIT_DONE: begin
                    start <= 0;
                    if (done) begin
                        count <= count + 1;
                        if (count == max_inputs - 1)
                            state <= IDLE;
                        else
                            state <= FEED;
                    end
                    done_out <= done;
                end
            endcase
        end
    end

endmodule
