module adder_wrapper (
    input  logic        clk,
    input  logic        rst,
    input  logic        start,

    output logic [16:0] result_out
);

    // Parameters
    localparam WIDTH = 16;

    // Internal signals
    logic [WIDTH-1:0] dataa;
    logic [WIDTH-1:0] datab;
    logic             cin;
    logic [WIDTH:0]   result;

    // Instantiate the unsigned adder
    unsigned_adder #(.WIDTH(WIDTH)) adder_inst (
        .dataa(dataa),
        .datab(datab),
        .cin(cin),
        .result(result)
    );

    // FSM state (simple sequence demo)
    typedef enum logic [1:0] {
        IDLE,
        SET_INPUTS,
        WAIT_RESULT
    } state_t;

    state_t state;

    // Input generator: produces some dynamic values for testing
    logic [7:0] count;

    always_ff @(posedge clk or posedge rst) begin
        if (rst) begin
            state       <= IDLE;
            dataa       <= 0;
            datab       <= 0;
            cin         <= 0;
            count       <= 0;
            result_out  <= 0;
        end else begin
            case (state)
                IDLE: begin
                    if (start)
                        state <= SET_INPUTS;
                end

                SET_INPUTS: begin
                    dataa <= {8'h00, count};           // Upper 8 bits zero
                    datab <= {8'h00, ~count};          // Complement of count
                    cin   <= count[0];                 // Use LSB as carry-in
                    count <= count + 1;
                    state <= WAIT_RESULT;
                end

                WAIT_RESULT: begin
                    result_out <= result;              // Capture result
                    state <= IDLE;
                end
            endcase
        end
    end

endmodule
