#!/bin/bash

THREAD_COUNTS=(1 2 3 4 5 6 7 8 9 10 11)
EXECUTABLE="stack exec SAT-Solver-exe"

OUTPUT_DIR="./results"
EVENTLOG_DIR="./eventlogs"
mkdir -p "$OUTPUT_DIR"
mkdir -p "$EVENTLOG_DIR"

for threads in "${THREAD_COUNTS[@]}"; do
    echo "Running SAT-Solver with $threads thread(s)..."

    OUTPUT_FILE="$OUTPUT_DIR/output_threads_${threads}.txt"
    EVENTLOG_FILE="$EVENTLOG_DIR/SAT-Solver-threads-${threads}.eventlog"

    time $EXECUTABLE -- +RTS -N"$threads" -l -s > "$OUTPUT_FILE" 2>&1

    if [ -f "SAT-Solver-exe.eventlog" ]; then
        mv "SAT-Solver-exe.eventlog" "$EVENTLOG_FILE"
        echo "Eventlog saved to $EVENTLOG_FILE"
    else
        echo "Warning: Eventlog not found for $threads thread(s)."
    fi

    if [ $? -eq 0 ]; then
        echo "Run with $threads thread(s) completed successfully. Output saved to $OUTPUT_FILE"
    else
        echo "Run with $threads thread(s) failed. Check $OUTPUT_FILE for details."
    fi
done

echo "All runs completed. Check '$OUTPUT_DIR' for outputs and '$EVENTLOG_DIR' for eventlogs."
