{-# LANGUAGE DeriveAnyClass #-}
{-# LANGUAGE DeriveGeneric #-}

module DPLL.Literal
  ( Var,
    var_Undef,
    Lit (..),
    lit_Undef,
    lit_Error,
    mkLit,
    neg,
    sign,
    var,
    index,
    toLit,
    unsign,
    idLit,
    toDimacs,
  )
where

import Data.Bits (complement, shiftR, xor, (.&.))
import GHC.Generics (Generic)
import Control.DeepSeq (NFData)

type Var = Int

var_Undef :: Int
var_Undef = -1

data Lit = Lit {x :: Int}
  deriving (Eq, Show, Generic, NFData)

lit_Undef :: Lit
lit_Undef = Lit (2 * var_Undef)

lit_Error :: Lit
lit_Error = Lit (2 * var_Undef + 1)

mkLit :: Var -> Bool -> Lit
mkLit v sgn = Lit ((v + v) + if sgn then 1 else 0)

neg :: Lit -> Lit
neg p = Lit (x p `xor` 1)

sign :: Lit -> Bool
sign p = x p .&. 1 == 1

var :: Lit -> Int
var p = x p `shiftR` 1

index :: Lit -> Int
index p = x p

toLit :: Int -> Lit
toLit i = Lit i

unsign :: Lit -> Lit
unsign p = Lit (x p .&. complement 1)

idLit :: Lit -> Bool -> Lit
idLit p sgn = Lit (x p `xor` (if sgn then 1 else 0))

toDimacs :: Lit -> Int
toDimacs p = if sign p then -(var p) - 1 else var p + 1
