{-# LANGUAGE DeriveAnyClass #-}
{-# LANGUAGE DeriveGeneric #-}

module DPLL.Clause
  ( Clause (..),
    mkClause,
    clauseSize,
    getLit,
    isLearnt,
    setActivity,
    getActivity,
  )
where

import DPLL.Literal (Lit)
import GHC.Generics (Generic)
import Control.DeepSeq (NFData)

data Clause = Clause
  { literals :: [Lit],
    learnt :: Bool,
    activity :: Maybe Float
  }
  deriving (Show, Eq, Generic, NFData)

mkClause :: Bool -> [Lit] -> Clause
mkClause isLearned ps = Clause {literals = ps, learnt = isLearned, activity = Nothing}

clauseSize :: Clause -> Int
clauseSize clause = length (literals clause)

getLit :: Clause -> Int -> Maybe Lit
getLit clause i
  | i >= 0 && i < clauseSize clause = Just (literals clause !! i)
  | otherwise = Nothing

isLearnt :: Clause -> Bool
isLearnt = learnt

setActivity :: Clause -> Float -> Clause
setActivity clause act = clause {activity = Just act}

getActivity :: Clause -> Maybe Float
getActivity = activity
