# SAT-Solver
Team members: Yixuan Li, Phoebe Wang, Jiaqian Li

## Usage
1. clone the repository 
```
https://github.com/phoebeww/SAT-Solver.git
cd SAT-Solver
```
2. install dependencies:
```
stack install
```
3. compile the project:
```
stack build
```
4. run the program:
```
stack run
```
5. run tests on multiple threads:
```
./test_threads.sh
```

## Brute Force SAT Solver with Parallelism
It evaluates all possible assignments to a given Boolean formula in Conjunctive Normal Form (CNF)
to determine whether at least one assignment satisfies the formula. 
We use Haskell’s `parMap rdeepseq` to evaluate assignments concurrently.

Steps:
1. Generate all possible combinations of Boolean assignments for the variables.
2. Each assignment is evaluated against the CNF formula in parallel to determine whether it satisfies the formula.
3. Returns the first satisfying assignment (`Just Assignment`) or `Nothing` if no solution exists.

## DPLL Parallel SAT Solver
The search space is divided by branching on a small subset of variables at the start. Each combination of truth assignments for these variables defines an independent subproblem, which is assigned to a separate thread for evaluation.
We use Haskell’s `parMap rdeepseq` to evaluate assignments concurrently.

Steps:
1. Randomly select a small subset of variables from the formula.
2. Create all possible combinations of truth assignments (2^k combinations) for the selected variables.
3. Evaluate each assignment using DPLL in parallel to determine whether it satisfies the formula.

DPLL algorithm on each thread:
1. Pick a literal not yet assigned and guess its value (e.g., TRUE).
2. Recursively find other variables in the formula after assigning the decision literal.
3. If the formula becomes unsatisfiable, backtrack and try the opposite value.

## Parallel DPLL with Working Queue:
For the worker queue strategy, the search space is divided by branching on a small subset of variables at the start. Instead of directly assigning these subproblems to threads, they are added to a shared task queue. Multiple threads are launched to fetch subproblems from this queue and execute the DPLL algorithm independently.

1. Generate initial subproblems by selecting a small subset of variables
2. Add resulting subproblems to the task queue
3. Each thread fetches a task from the queue and attempts to solve
4. Threads keep working until the queue is empty or a solution is found

## SAT generator

1. Main Function: `generateSatisfiableCNF numVars numClauses clauseLen`
   takes: 
   - `numVars`: how many variables (e.g., 3 means x1, x2, x3)
   - `numClauses`: how many clauses to generate
   - `clauseLen`: how many literals per clause

2. Creating a Random Satisfying Assignment:
   ```
   randVals <- replicateM numVars (randomRIO (0, 1))
   let assignment = map (==1) randVals
   let satisfying = zipWith (\v b -> if b then v else -v) [1..numVars] assignment
   ```

   Example with numVars = 3:

   - randVals might be: [1, 0, 1]

   - assignment becomes: [True, False, True]

   - satisfying becomes: [1, -2, 3]

3. Generating Clauses (repeat `numClauses` times):
   For each clause:
   - Pick one literal from satisfying assignment
   - Generate rest of clause ensuring no contradictions

4. Helper Function: `generateClauseWithSat numVars len satLit`
   - Takes a satisfying literal (e.g., 1)
   - Builds a clause of length `len`
   - Ensures no `x` and `¬x` in same clause

   Example: 
   - satLit = 1
   - might generate: [1, -3, 2]