module BoardSpec (spec) where

import Board
import Test.Hspec

spec :: Spec
spec = do
  describe "Board operations" $ do
    it "creates an empty board" $ do
      let b = emptyBoard 3 3
      length (cells b) `shouldBe` 3
      all (all (==Empty)) (cells b) `shouldBe` True

    it "makes a move" $ do
      let b = emptyBoard 3 3
      let Just b2 = makeMove b PlayerX (0,0)
      (cells b2 !! 0 !! 0) `shouldBe` Mark PlayerX
