module Benchmark
( benchmarkSolver
) where

import Board
import SolverSequential
import SolverParallel
import System.CPUTime
import Text.Printf
import Control.DeepSeq (force)
import Control.Exception (evaluate)

benchmarkSolver :: IO ()
benchmarkSolver = do
    let sizes = [3]   -- [3,4,5]
    let player = PlayerX
    putStrLn "Benchmarking solver performance:"
    mapM_ (runBench player) sizes
  where
    runBench :: Player -> Int -> IO ()
    runBench player size = do
      let board = emptyBoard size size
      putStrLn $ "\nBoard size: " ++ show size ++ "x" ++ show size
      t1 <- timeAction $ bestMoveSequential board player
      putStrLn $ printf "Sequential time: %.3f ms" (t1 :: Double)
      t2 <- timeAction $ bestMoveParallel board player
      putStrLn $ printf "Parallel time:   %.3f ms" (t2 :: Double)

    timeAction :: Maybe (Int, Int) -> IO Double
    timeAction action = do
      start <- getCPUTime
      result <- evaluate $ force action
      end <- getCPUTime
      let diff = (fromIntegral (end - start)) / (10^9)  -- Convert to milliseconds
      return diff