# Generalized Tic Tac Toe Solver
## Student Name: Milin Saini
## Student UNI: mks2249

### Objective
Determining the optimal move in generalized Tic Tac Toe is an NP-complete problem, especially as the
board size and the number of players increase. This project aims to develop a parallelized solver for
generalized Tic Tac Toe using Haskell's func􀆟onal programming paradigms to enhance performance and
scalability.

### Pre-requisites
- Environment: GHC 6.9.9, Stack 3.1.1, Threadscope
- Can use GHCup to install required software

### How to run the code
- ``` stack build ```
- ``` stack test ``` 
- ``` stack exec generalized-tic-tac-toe-solver ```

### For Parallel execution
- ```stack clean``` 
- ```stack build --profile```

### Profiling with threadscope
- ```stack exec ttt4-exe -- 3 +RTS -N4 -l -RTS -s -ls```
- ```threadscope ttt4-exe.EXE.eventlog```


### Code Structure
ttt4/
├── stack.yaml
├── package.yaml
├── src
│   ├── Main.hs
│   ├── Board.hs
│   ├── SolverSequential.hs
│   ├── SolverParallel.hs
│   ├── Benchmark.hs
└── test
    └── Spec.hs