module Main (main) where

import System.Exit(die)
import System.Environment(getArgs, getProgName)

import DIMACSParser
import Lib(constructTree, dpll, satisfyParDPLL)
import qualified Data.Vector as V

main :: IO ()
main = do 
  args <- getArgs
  case args of
    [filename] -> do
      content <- readFile filename
      case parseDIMACS content of
        Left err -> die $ "Error parsing DIMACS input file: " ++ err
        Right (numVars, clauses) -> do
          let cnf = constructTree clauses 
          let initialAssignment = V.replicate numVars Nothing
              (seqDpllResult, assignment) = satisfyParDPLL 25 cnf initialAssignment
          putStrLn $ "Sequential DPLL Solver result: " ++ if seqDpllResult then "SAT: "++(show assignment) else "UNSAT"
    _ -> do
      progName <- getProgName
      die $ "Usage: " ++ progName ++ " <filename>"

