{-# OPTIONS_GHC -Wall #-}
module Main where

import RubikCube

-- Test applying a single move and its inverse
testSingleMoveF :: IO ()
testSingleMoveF = do
    let n = 3
    let cube = initCube n
    putStrLn "initial Cube:"
    printCube cube

    let cubeAfterF = applyMove F cube
    putStrLn "\nCube after move F:"
    printCube cubeAfterF

    let cubeAfterFi = applyMove Fi cubeAfterF
    putStrLn "\nCube after move Fi (should be back to initial state):"
    printCube cubeAfterFi

    if cubeAfterFi == cube
        then putStrLn "\nTest Passed: moveF and moveFi are inverses."
        else putStrLn "\nTest Failed: moveF and moveFi are not inverses."


testSingleMoveR :: IO ()
testSingleMoveR = do
    let n = 3
    let cube = initCube n
    putStrLn "initial Cube:"
    printCube cube

    let cubeAfterR = applyMove R cube
    putStrLn "\nCube after move R:"
    printCube cubeAfterR

    let cubeAfterRi = applyMove Ri cubeAfterR
    putStrLn "\nCube after move Ri (should be back to initial state):"
    printCube cubeAfterRi

    if cubeAfterRi == cube
        then putStrLn "\nTest Passed: moveR and moveRi are inverses."
        else putStrLn "\nTest Failed: moveR and moveRi are not inverses."


-- Test applying multiple moves and their inverses
testMoves :: IO ()
testMoves = do
    let n = 3 -- Cube size
    let solvedCube = initCube n
    putStrLn "Solved Cube:"
    printCube solvedCube

    -- Apply a sequence of 30 moves involving all 12 types of move...
    let scrambleMoves = 
            [ U, R, F, B, L, D,
              Ui, Ri, Fi, Bi, Li, Di,
              U, R, F, B, L, D,
              Ui, Ri, Fi, Bi, Li, Di,
              U, R, F, B, L, D
            ]
    let scrambledCube = applyMoves scrambleMoves solvedCube
    
    putStrLn "\nScrambled Cube (after U, R, F, B, L, D, Ui, Ri, Fi, Bi, Li, Di, U, R, F, B, L, D, Ui, Ri, Fi, Bi, Li, Di, U, R, F, B, L, D):"
    printCube scrambledCube

    -- Manual check: operate the same moves on https://rubiks-cube-solver.com/ and get the result faces
    -- Expected output
    -- Up Face:
    -- "OGR"
    -- "OWR"
    -- "GBW"
    -- Front Face:
    -- "WWB"
    -- "OGR"
    -- "OYB"
    -- Right Face:
    -- "OWB"
    -- "BRG"
    -- "OYY"
    -- Back Face:
    -- "WWG"
    -- "RBO"
    -- "GYY"
    -- Left Face:
    -- "WWR"
    -- "GOB"
    -- "RYY"
    -- Down Face:
    -- "GBY"
    -- "OYR"
    -- "BGR"

    -- Apply inverse moves
    let reverseRestoreMoves =
            [ Di, Li, Bi, Fi, Ri, Ui,
              D, L, B, F, R, U,
              Di, Li, Bi, Fi, Ri, Ui,
              D, L, B, F, R, U,
              Di, Li, Bi, Fi, Ri, Ui
            ]
    let restoredCube = applyMoves reverseRestoreMoves scrambledCube

    putStrLn "\nRestored Cube (after Di, Li, Bi, Fi, Ri, Ui, D, L, B, F, R, U, Di, Li, Bi, Fi, Ri, Ui, D, L, B, F, R, U, Di, Li, Bi, Fi, Ri, Ui):"
    printCube restoredCube

    -- Check if the restored cube matches the solved cube
    if restoredCube == solvedCube
        then putStrLn "\nTest Passed: Cube restored to solved state."
        else putStrLn "\nTest Failed: Cube not restored to solved state."


main :: IO ()
main = do
    putStrLn "Running testSingleMoveF:"
    testSingleMoveF
    putStrLn "\nRunning testSingleMoveR:"
    testSingleMoveR
    putStrLn "\nRunning testMoves:"
    testMoves